/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8230.DeviceView;

import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm8230.DeviceView.ChassisLike;
import ibm.nways.jdm8230.DeviceView.PortRI_ROLike;
import ibm.nways.ras.RAS;
import java.awt.Point;
import java.util.ResourceBundle;

public abstract class PortRI_RO
implements PortRI_ROLike {
    protected String backgroundGif = "";
    protected GraphicImage portGraphicImage;
    protected int portType;
    protected Point location;
    protected int lobeIndex;
    protected GraphicContainer graphicContainer;
    protected GraphicContainer portContainer = new GraphicContainer();
    protected static final String BUNDLE_NAME = "ibm.nways.jdm8230.DeviceView.GraphicResources";
    protected static ResourceBundle resources = ResourceBundle.getBundle("ibm.nways.jdm8230.DeviceView.GraphicResources");
    protected static final String SER_PATH = "ibm.nways.jdm8230.WCDefault";
    protected static final String DEST_PANEL = "ibm.nways.jdm8230.eui.GeneralPanel";
    protected static final int COOKIE_FLAGS = 20;
    protected String cookieID;
    protected GenModel generalTableModel;
    protected JdmBrowser jdmBrowser;
    protected ChassisLike chassis;
    protected static final String[] PORT_TYPE = new String[]{"Port_unknown", "Port_fiber", "Port_ics", "Port_rj45"};
    public static final int UNKNOWN = 1;
    public static final int FIBER = 2;
    public static final int COOPER_ICS = 3;
    public static final int COOPER_RJ45 = 4;

    public void dispose() {
        if (this.graphicContainer != null) {
            this.graphicContainer.dispose();
            this.graphicContainer = null;
        }
        if (this.portContainer != null) {
            this.portContainer.dispose();
            this.portContainer = null;
        }
        this.portGraphicImage = null;
        this.location = null;
        this.generalTableModel = null;
        this.jdmBrowser = null;
        this.chassis = null;
    }

    public void draw() {
        this.graphicContainer.add(this.portContainer);
    }

    public GenModel getModel() {
        block2: {
            if (this.generalTableModel != null) break block2;
            try {
                GenModel genModel = (GenModel)this.jdmBrowser.getModel();
                genModel = (GenModel)genModel.getComponent("ConfigurationFolder");
                genModel = (GenModel)genModel.getComponent("SystemFolder");
                genModel = (GenModel)genModel.getComponent("DeviceFolder");
                this.generalTableModel = (GenModel)genModel.getComponent("GeneralFolder");
            }
            catch (Exception exception) {
                RAS.logException(19, 4, this, "getModel", exception);
            }
        }
        return this.generalTableModel;
    }

    public ModelInfo getModelInfo() {
        ModelInfo modelInfo = new ModelInfo();
        modelInfo.add("Panel.CauRIMediaType");
        modelInfo.add("Panel.CauROMediaType");
        return modelInfo;
    }

    public String getDestinationPanel() {
        return DEST_PANEL;
    }

    public final void setCommonInformation(ChassisLike chassisLike, JdmBrowser jdmBrowser, GenModel genModel, int n, int n2, GraphicContainer graphicContainer) {
        this.jdmBrowser = jdmBrowser;
        this.chassis = chassisLike;
        this.generalTableModel = genModel;
        this.lobeIndex = n;
        this.portType = n2;
        this.graphicContainer = graphicContainer;
    }

    public I18NMsgFormat getFlyOverText() {
        Object[] objectArray = new Object[2];
        String string = "Unknown";
        string = this.lobeIndex == 1 ? new String("RI") : new String("RO");
        objectArray[0] = resources.getString(string);
        String string2 = "Port_unknown";
        try {
            string2 = PORT_TYPE[this.portType - 1];
        }
        catch (Exception exception) {
            RAS.logWarning(19, 4, this, "getFlyOverText", "Cannot find fly-over for port type -> " + this.portType);
        }
        objectArray[1] = resources.getString(string2);
        return new I18NMsgFormat(BUNDLE_NAME, "RI_ROPort", objectArray);
    }

    public void setSpecificInformation() {
    }

    public void discoverChildren() {
    }

    public final void setLocation(Point point) {
        this.location = point;
        this.portContainer.setLocation(this.location.x, this.location.y);
    }
}

